package edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms;

import edu.unl.consystlab.sudokuSolver.constraintProblem;
import edu.unl.consystlab.sudokuSolver.nonBinaryIntensiveConstraint;

public class nonBinaryRestrictedArcConsistency extends consistencyAlgorithm {

	private String location;
	
	public nonBinaryRestrictedArcConsistency(constraintProblem newProblem, String newLocation) {
		super(newProblem);
		location = newLocation;
	}

	public boolean runAlgorithm()
	{
		
		parentProblem.registerDomainReductionListener(variableReductions);
		
		if(((nonBinaryIntensiveConstraint)
				(parentProblem.getNonBinaryIntensiveConstraint(location))).updateGraph() == null)
		{
			//if it is null then there is an error in the constraint
			brokenConstraint = (parentProblem.getNonBinaryIntensiveConstraint(location));
			setEncounteredError(true);
			parentProblem.unregisterDomainReductionList(variableReductions);
			return false;
		}
		else
		{
			brokenConstraint = null;
			setEncounteredError(false);
			parentProblem.unregisterDomainReductionList(variableReductions);
			return true;
		}
	}
}
